package ibase.marketingCampaign;

import java.rmi.RemoteException;
import java.sql.Connection;

import java.util.*;
import java.sql.*;

import org.w3c.dom.Document;
import org.w3c.dom.*;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class MailingListPostSave extends ValidatorEJB {

	public String postSave() throws RemoteException, ITMException {
		return "";
	}

	public String postSave(String domString, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException {
	    System.out.println("In VoucherPostSave ... ");
	    BaseLogger.log("3", null, null, "In MailingListPreSave method ");

	    PreparedStatement pstmt = null;
	    PreparedStatement pstmt2 = null;
	    PreparedStatement pstmt3 = null;
	    Document dom = null;                
	    ResultSet rs = null;
	    boolean isError = false;
	    String selectSQLStr = ""; // this query will get name and email ID. 
	    String MailListID = "";

	    try {
	        // Delete existing records
	        String deleteSQL = "DELETE FROM mailing_list_det";
	        pstmt3 = conn.prepareStatement(deleteSQL);
	        int rowsDeleted = pstmt3.executeUpdate();
	        BaseLogger.log("3", null, null, "MailingListPostSave : Deleted rows count :: [" + rowsDeleted + "]");
	        conn.commit();

	        E12GenericUtility genericUtility = new E12GenericUtility();
	        dom = genericUtility.parseString(domString);
	        BaseLogger.log("3", null, null, "MailingListPostSave : DOM :: [" + dom + "]");
	        selectSQLStr = genericUtility.getColumnValue("sql_str", dom);
	        BaseLogger.log("3", null, null, "MailingListPostSave : sql value :: [" + selectSQLStr + "]");
	        MailListID = genericUtility.getColumnValue("mail_list_id", dom);
	        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + MailListID + "]");

	        pstmt = conn.prepareStatement(selectSQLStr);
	        rs = pstmt.executeQuery();

	        int rowCount = 0;
	        int lineNo = 1;
	        String[] selectParts = selectSQLStr.toLowerCase().split("from")[0].replace("select", "").trim().split(",");
	        String firstColumn = selectParts[0].trim();
	        String secondColumn = selectParts.length > 1 ? selectParts[1].trim() : "";

	        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + firstColumn + "]");
	        BaseLogger.log("3", null, null, "MailingListPostSave : mail_list_id :: [" + secondColumn + "]");

	        pstmt2 = conn.prepareStatement("INSERT INTO mailing_list_det (MAIL_LIST_ID, LINE_NO, EMAIL_ID, NAME) VALUES (?, ?, ?, ?)");
	        while (rs.next()) {
	            rowCount++;
	            String name = rs.getString(firstColumn);
	            String emailId = rs.getString(secondColumn);
	            BaseLogger.log("3", null, null, "MailingListPostSave : name :: [" + name + "]");
	            BaseLogger.log("3", null, null, "MailingListPostSave : emailId :: [" + emailId + "]");

	            pstmt2.setString(1, MailListID);
	            pstmt2.setInt(2, lineNo);
	            pstmt2.setString(3, emailId);
	            pstmt2.setString(4, name);
	            pstmt2.addBatch(); // Add to batch
	            lineNo++;

	            // Execute batch every 100 inserts (or adjust as needed)
	            if (lineNo % 100 == 0) {
	                pstmt2.executeBatch();
	                pstmt2.clearBatch(); // Clear the batch after execution
	            }
	        }
	        // Execute any remaining batch
	        pstmt2.executeBatch();

	        BaseLogger.log("3", null, null, "MailingListPostSave : Total rows in result set :: [" + rowCount + "]");
	        conn.commit();
	        BaseLogger.log("3", null, null, "MailingListPostSave : All inserts completed!");

	    } catch (Exception e) {
	        BaseLogger.log("3", null, null, "MailingListPostSave : exception in try block: " + e.getMessage());
	        isError = true;

	    } finally {
	        // Close resources properly
	        if (rs != null) try { rs.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
	        if (pstmt != null) try { pstmt.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
	        if (pstmt2 != null) try { pstmt2.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
	        if (pstmt3 != null) try { pstmt3.close(); } catch (SQLException e) { BaseLogger.log("3", null, null, "MailingListPostSave : in catch"); }
	    }

	    return "";
	}


}
